namespace ReportTests.Models;

// Inventory report model
public class InventoryReportModel
{
    public List<InventoryItem> Items { get; set; } = new();
    public int LowStockThreshold { get; set; } = 20;
    public int CriticalStockThreshold { get; set; } = 5;
    public DateTime GeneratedDate { get; set; } = DateTime.Now;
}

// Individual inventory item
public class InventoryItem
{
    public string SKU { get; set; } = string.Empty;
    public string ProductName { get; set; } = string.Empty;
    public int Quantity { get; set; }
    public decimal UnitCost { get; set; }
    public string Category { get; set; } = string.Empty;
}
