# Crystal Reports Alternative - IronPDF Test Suite

This test project validates all code examples from the "How to Generate Reports in C# Without Crystal Reports" tutorial.

## Prerequisites

- .NET 8.0 SDK
- IronPDF NuGet package (automatically installed)
- IronPDF license key (optional for trial mode)

## Project Structure

```
ReportTests/
├── Models/
│   ├── InvoiceModels.cs      # Invoice, Company, Customer, LineItem
│   ├── EmployeeModels.cs     # Employee, Department, Directory
│   ├── InventoryModels.cs    # Inventory items and thresholds
│   └── SalesModels.cs        # Sales data for charts
├── Templates/
│   └── HtmlTemplates.cs      # HTML templates for all report types
├── Program.cs                # Main test runner with 10 tests
└── output/                   # Generated PDFs (created at runtime)
```

## Running the Tests

### Option 1: With License Key (No Watermarks)

```bash
# Set environment variable
set IRONPDF_LICENSE_KEY=your-license-key-here
cd ReportTests
dotnet run

# Or pass as argument
dotnet run -- --license=your-license-key-here
```

### Option 2: Trial Mode (With Watermarks)

```bash
cd ReportTests
dotnet run
```

Note: Trial mode will add watermarks to generated PDFs but all functionality will work.

## Tests Included

| # | Test | Description |
|---|------|-------------|
| 1 | Quickstart Example | Basic HTML to PDF conversion |
| 2 | Invoice Generation | Full invoice with line items, totals, tax |
| 3 | Text Headers/Footers | Page numbers, dates, merge fields |
| 4 | HTML Headers/Footers | Custom styled headers with CSS |
| 5 | Employee Directory | Multi-page with department groupings |
| 6 | Sales Chart | Chart.js visualization with JavaScript |
| 7 | Inventory Report | Conditional formatting for stock levels |
| 8 | Combined Reports | Merging multiple PDFs |
| 9 | Table of Contents | Auto-generated TOC from headings |
| 10 | Batch Processing | Parallel generation of multiple invoices |

## Output

All generated PDFs are saved to the `output/` directory:

- `01-quickstart.pdf`
- `02-invoice.pdf`
- `03-text-headers-footers.pdf`
- `04-html-headers-footers.pdf`
- `05-employee-directory.pdf`
- `06-sales-chart.pdf`
- `07-inventory-report.pdf`
- `08-combined-report.pdf`
- `09-table-of-contents.pdf`
- `10-batch-INV-2026-001.pdf` through `10-batch-INV-2026-005.pdf`

## Code Examples Validated

This test suite validates the following code blocks from the tutorial:

1. **Quickstart** - `RenderHtmlAsPdf` one-liner
2. **Invoice Models** - `InvoiceModel`, `CompanyInfo`, `CustomerInfo`, `LineItem`
3. **Invoice Template** - Full Razor-style HTML/CSS template
4. **Data Binding** - `ChromePdfRenderer` with margins and paper size
5. **Text Headers/Footers** - `TextHeaderFooter` with merge fields
6. **HTML Headers/Footers** - `HtmlHeaderFooter` with CSS
7. **Employee Directory** - `EmployeeDirectoryModel`, `Department`, `Employee`
8. **Charts** - Chart.js integration with `WaitFor.JavaScript()`
9. **Conditional Formatting** - CSS classes based on data values
10. **Merged Reports** - `PdfDocument.Merge()`
11. **Table of Contents** - `TableOfContentsTypes.WithPageNumbers`
12. **Batch Processing** - `Parallel.ForEachAsync` with `RenderHtmlAsPdfAsync`

## Getting a License

- Free trial: https://ironpdf.com/csharp/pdf/
- Purchase: https://ironpdf.com/licensing/
